using System;

class Program
{
    struct Mast
    {
        public int x;
        public int h;
        public int index;
    }

    static void Main(string[] args)
    {
        int n = int.Parse(Console.ReadLine());

        string[] xs = Console.ReadLine().Split(' ');
        string[] hs = Console.ReadLine().Split(' ');

        Mast[] a = new Mast[n];

        for (int i = 0; i < n; i++)
        {
            a[i].x = int.Parse(xs[i]);
            a[i].h = int.Parse(hs[i]);
            a[i].index = i;
        }


        Array.Sort(a, delegate (Mast m1, Mast m2)
        {
            return m1.x.CompareTo(m2.x);
        });

        int[] left = new int[n];
        int[] right = new int[n];

        for (int i = 0; i < n; i++)
        {
            left[i] = -1;
            right[i] = -1;
        }

     
        int[] stack = new int[n];
        int top = -1;


        for (int i = 0; i < n; i++)
        {
            while (top >= 0 && a[stack[top]].h < a[i].h)
                top--;

            if (top >= 0)
                left[i] = stack[top];

            stack[++top] = i;
        }

        top = -1;


        for (int i = n - 1; i >= 0; i--)
        {
            while (top >= 0 && a[stack[top]].h < a[i].h)
                top--;

            if (top >= 0)
                right[i] = stack[top];

            stack[++top] = i;
        }

        int[] result = new int[n];

        for (int i = 0; i < n; i++)
        {
            int best = int.MaxValue;

            if (left[i] != -1)
                best = Math.Abs(a[i].x - a[left[i]].x);

            if (right[i] != -1)
                best = Math.Min(best, Math.Abs(a[right[i]].x - a[i].x));

            if (best == int.MaxValue)
                result[a[i].index] = -1;
            else
                result[a[i].index] = best;
        }

        for (int i = 0; i < n; i++)
            Console.WriteLine(result[i]);
    }
}